;-----------------------------------
; Evoke 2023 - 256 bytes intro
; V1.2 Post Party Version
; Jul 2023
; BIOS - DOS
;------------------------------------
;------------------------------------
; ASMSX Variables
;------------------------------------
USE_SCREEN=5		; Defines Screen for that Intro
;------------------------------------
; EQUs - Defines
;------------------------------------
SCREEN_BIOS	equ	05Fh
EXPTBL		equ	0FCC1h
; HighSpeed VDP CMD MSX2 Used in this Intro: 
CMDRECTFAST	equ	0C0h	; Fill Rectangle Fast HMMV (No logical)
;------------------------------------
; ASMSX Directives
;------------------------------------
	ZILOG
	BIOS
	MSXDOS
	
	org	100h

;------------------------------------
; Copy Rutine to move Intro to 4000h - Page 1
;------------------------------------
__INI_CODE:
	di
	ld	BC, __END_256 - INIT
	ld	HL, __INIT_256
	ld	DE, 04000h
	ldir
	jp	INIT
;------------------------------------
; Macros
;------------------------------------
; A = Data to Write to Register
m_WRITE_VDP_REGISTER: MACRO #REG
	out	(99h),A
	ld	A,80h + #REG	; Register to Write
	out	(99h),A
ENDM

; Flag NZ if V-Blank happens
m_CHECK_VBLANK: MACRO
	xor	A		; Status Register 0
	out	(99h),A
	ld	A,80h + 0Fh	; Register 0Fh: Status Register Index
	out	(99h),A
	;in	A,(99h)
	;and	10000000b 	; 7    F     V-Blank IRQ Flag (1=interrupt)
ENDM
;------------------------------------
; INTRO Starts HERE
;------------------------------------
__INIT_256:
	PHASE 4000h
INIT:
;********
; SCREEN
;********
	ld	A,USE_SCREEN
	ld 	IY,(EXPTBL-1)
	ld 	IX,SCREEN_BIOS
	call 	CALSLT
; Video Mode configuration and Enable V-Blank
	; 0 bit 0 Zoom x1 0
	; 1 bit 1 Sprites 16x16
	; 1 bit 5 V-Blank Enable
	; 1 bit 6 Screen Enable
	ld	A,62h
	m_WRITE_VDP_REGISTER 01h	; Register 1: Mode register 1
; Visible VRAM Page (0-3)
	ld	A,3Fh	; Page 0,1,2,3: 1F,3F,5F,7F (0XX1 1111)
	m_WRITE_VDP_REGISTER 02h	; Register 2: Bitmap Table
; Change Border color
	xor	A
	m_WRITE_VDP_REGISTER 07h	; Register 7: colour register.
; More configuration for Video Mode
	; 1 bit 1 Disable Sprites
	; 1 bit 5 Transparent color 0 from palette is Solid
	ld	A,2Ah
	m_WRITE_VDP_REGISTER 08h	; Register 8: Mode register 2
; Put Palette to VDP
	xor	A
	m_WRITE_VDP_REGISTER 10h	; Register 10: Palette index
	ld	B,16		; 16 loop to send data to port 9A
	ld	HL,GREY_PAL	; Palette position
.loop:
	ld	A,(HL)
	out	(9Ah),A	; Without NOPs
	out	(9Ah),A	; Without NOPs
	inc	HL
	djnz	.loop
; Draw color lines with VDP command
	ld	B,64
DRAW:
	push	BC
	call	VDP_DRAW
	ld	A,(COM_CLRSCR+2)
	sub	4
	ld	(COM_CLRSCR+2),A	; Change Y
	ld	A,(COM_CLRSCR+8)
	inc	A
	and	0Fh
	ld	B,A
	rrc	A
	rrc	A
	rrc	A
	rrc	A
	or	B
	ld	(COM_CLRSCR+8),A	; Change color
	pop	BC
	djnz	DRAW
;********
; Setup VDP INT Rutine at 0FD9A
;********
	ld	HL,0FD9Ah
	ld      BC,INTERRUPT
	ld      (HL),0C3h
	inc     HL
	ld      (HL),C
	inc     HL
	ld      (HL),B
	ei
;********
; Main loop
;********
.MAIN_LOOP:
	halt
	jr	.MAIN_LOOP
;------------------------------------
; VDP Interrupt Rutine
;------------------------------------
INTERRUPT:
	; Read Status Register 0 (To Reset VBlank)
	m_CHECK_VBLANK
	; Flag NZ if V-Blank happens (Always happens, no other Interrupt)
.VBLANK:
	ld	A,(RAM_INC1)
	m_WRITE_VDP_REGISTER 17h	; Register 17h: Vertical Scroll
	ld	A,(RAM_INC1)
	inc	A
	ld	(RAM_INC1),A
	ret

INTERRUPT_END:
;------------------------------------
; DATA
;------------------------------------
GREY_PAL:
	;	RB,G !!
	db	00h;,  0h
	db	11h;,  1h
	db	21h;,  2h
	db	32h;,  3h
	db	43h;,  4h
	db	54h;,  5h
	db	65h;,  6h
	db	76h;,  7h
	db	67h;,  7h
	db	76h;,  6h
	db	65h;,  5h
	db	54h;,  4h
	db	43h;,  3h
	db	32h;,  2h
	db	21h;,  1h
	db	11h;,  0h
;------------------------------------
; CALLS
;------------------------------------
; Command Rectangle
COM_CLRSCR:
; 		36,37,38 YPos,39,40,41,42       ,43,44      ,45,46
;		4 ,5 ,6      ,7 ,8 ,9 ,10 height,11,12 color,13,14
	db	0 ,0 ,212    ,1 ,0 ,1 ,4        ,0 ,011h    ,0 ,CMDRECTFAST
VDP_DRAW:
	ld	HL,COM_CLRSCR
; Wait for CE bit
	ld	A,02h
	m_WRITE_VDP_REGISTER 0Fh	; Register 0Fh: Status Register Index
.wait:
	in	A,(099h)
	and	1
	jr	nz,.wait	; Wait if VDP is busy

	ld	A,24h	; Comando start at Register 24h
	m_WRITE_VDP_REGISTER 11h	;Register 11h: Register pointer
	ld	B,11	; 11 time data to a port 09Bh
.loop:
	ld	A,(HL)
	out	(09Bh),A	; Without NOPs - Port VDP per indirecte
	inc	HL
	djnz	.loop
	ret
__END_256:
;------------------------------------
; Variables : RAM
;------------------------------------
__INI_RAM:
RAM_INC1:	byte	; Increment 1 per HBlank
__END_RAM:

;------------------------------------
; TXT Report
;------------------------------------
PRINTTEXT "------------------------------------"
PRINTTEXT "Code:"
PRINT __END_256 - INIT + [__INIT_256 - __INI_CODE]
PRINTTEXT "------------------------------------"
PRINTTEXT "to 256:"
PRINT 256 - [__END_256 - INIT + [__INIT_256 - __INI_CODE]]
PRINTTEXT "------------------------------------"
PRINTTEXT "Copied:"
PRINT __END_256 - INIT
PRINTTEXT "------------------------------------"
PRINTTEXT "Header:"
PRINT __INIT_256 - __INI_CODE
PRINTTEXT "------------------------------------"
PRINTTEXT "RAM:"
PRINT __END_RAM - __INI_RAM
PRINTTEXT "------------------------------------"