/******************************************************************************
 * SouthParty.cpp - Implementacin del mtodo run de la clase App.
 *
 * Mantenido por: Tony Cabello aka Dr.Kami/MCD - is05678@salleurl.edu 
 *
 * Versin: 1.0a (1-Enero-2K)
 *
 * Esta es una parte del proyecto TIGER: http://www.4bytes.com/tiger/
 *****************************************************************************/

#include "../../tiger/tiger.h"

#define a 690
#define b 42181

#define SCREEN_WIDTH 640
#define SCREEN_HEIGHT 480

char Textos[30][300] = { "Acidbeat a la izquierda haciendose una foto con Jacobo que vino a visitarnos desde su pueblo en Teruel.",
					     "Acidbeat en accion en su faceta como dj. Aqui podemos verle a los mandos de una mc303 de Roland realizando un set con Sml. Fijaros en Flat Eric... que es lo que tiene entre piernas? XD",
						 "Dios mio!, yo en una fiesta y con 39 de fiebre. Deberia estar en la cama..",
						 "La fiesta dispuso de un rincon apartado de la musica para poder estar mas tranquilo y poder hablar sin dar gritos. En la imagen aparecen, (de izquierda a derecha): Javier, Gonzalo, Carlos, Miguel Angel, Jacobo y detras de el, otro Jacobo.",
						 "A ultima hora, mientras Sml y dVD se encargaban de ambientar musicalmente la fiesta, en el proyector de video se improviso un chat con el Wordpad... Si es que estos sceners... XD",
						 "trace (a la izquierda), Pasop (a la derecha) y Jacobo en medio animando a bailar.",
						 "Coonnyo, vaya peooo!",
						 "Es necesario todo ese montaje para realizar una fiesta con amigos? Y quien es ese idiota y hortera vestido de naranja con girnalda? No podia ser otro que JamQue.",
						 "Joder que frio! Me cubrire con la camisa lila hortera de Jamquito..",
						 "Ricardito, Ricardito, Donde estas?!",
						 "Dejalo, no me hagas foto que tengo suenyo!",
						 "Soy de pueblo y estoy sin vacunar..",
						 "Si, ya lo se, no llevo maquillaje y encima me he dejado la peineta",
						 "Chicas! donde estan las pivas en esta fiesta?",
						 "Esta musica no hay quien la aguante, No podriais poner otra vez la Monica Naranjo?",
						 "El arma de batalla de Sml estubo alli y sirvio para anyadirle unos bass drum al SOS de Abba al estilo Hyperventilaton.",
						 "Me quito las gafas y a ver si me pillas el lado bueno, eh?",
						 "Fua!, si es que soy la bomba: Soy coder y encima no bailo mal",
						 "Lo mas codiciado por un scener: el proyector para ver las demos muy muy grandes, sino mirad la cara de Ufix. Se lo llevaria a casa si le entrara en la mochila.",
						 "Los 3 amigos bailando (de izquierda a derecha) Hernan, Tai y trace.",
						 "La foto bomba de la fiesta. (de izquierda a derecha) trace, Ufix y Pasop bailando al estilo scener. Al fondo Mauri esperando a su novia Maria a que saliera del lavabo.",
						 "dVD (a la izquierda) y Sml (a la derecha) realizaron un set inolvidable cargado de loops y breakbeats. Es posible que dVD sea mas hortera que el chaval de la peca en el momento de elegir camisas? XD",
						 "Una foto?, bueno va, pero que no se repita..",
						 "En la imagen dos sceners a los mandos de la cabina. dVD en la mc303 y Sml a cargo de los MP3.",
						 "XDDDD",
						 "Estubiste destinado en tananga? Cooonnnyooo!",
						 "Una pletina, un CD con pitch, un discman, un plato, 2 ordenadores, 2 mesas de mezclas y una mc303. Un equipo completo.",
						 "Puedo llevarme ese proyector a casa?",
						 "Hernan (a la izquierda), trace y Tai (en el centro) no dejaban de mirar las proyecciones de video. Pasop (a la derecha) bailando a su bola.",
						 "Si el amplificador deja de sonar... Es culpa mia?" };

char TextosJ[30][300];
int Lines[30];

//**************** RUN *******************************

void App::run(void) {

	int t;

	Speaker speaker;
	Module module;
	
	//********************** LOADING TIGER SPLASH ******************************

	Screen.set("South Party Intro");
  	Screen.set(Option::Mode, Mode(SCREEN_WIDTH, SCREEN_HEIGHT, GraphicsMode, ColorFormat(ColorFormat::DirectRGB16)));

	Curve FadeFlashblack1, project_cv;
	FileManager.loadCurve("tiger/Fadeblack1", FadeFlashblack1);
	FileManager.loadCurve("tiger/project", project_cv);

	Scene3D tiger;
	FileManager.loadScene3D("tiger", tiger);
	tiger.prepare(Screen);

	Texture trama1, trama2, project;
	FileManager.loadBitmap("tiger/trama1", trama1);
	FileManager.loadBitmap("tiger/trama2", trama2);
	FileManager.loadBitmap("tiger/project", project);
 	trama1.prepare(Screen.videoBuffer);
	trama2.prepare(Screen.videoBuffer);
	project.convert(ColorFormat::IndexedRGB32);

	trama1.set(Option::TargetRect, Rect<float>(0.0f, 30.0f/240.0f, 1.0f, 22.0f/240.0f));
	trama2.set(Option::TargetRect, Rect<float>(0.0f, 188.0f/240.0f, 1.0f, 22.0f/240.0f));
	
	trama1.set(DrawMode::TranspSub);
	trama2.set(DrawMode::TranspSub);
	project.set(DrawMode::TranspAlpha);
	project.set(Option::TargetRect, Rect<float>(182.0f/320.0f, 146.0f/240.0f, 110.0f/320.0f, 14.0f/240.0f));
	project.genPal(0, 255, 0.0f, 0.0f);

	tiger.set(NULL, Option::BoundingTest, false);

  	//********************** TIGER SPLASH ******************************	

	speaker.init(Screen);
//	module.load("tiger.xm");
//	module.start();

	Timer.start();

	Color3 purple(42.0f/255.0f, 55.0f/255.0f, 61.0f/255.0f);
	Screen.videoBuffer.clearColor(purple);

	Screen.viewport(0, (SCREEN_HEIGHT*30)/240, SCREEN_WIDTH, (SCREEN_HEIGHT*180)/240);

	while (((t = Timer.getMillis()) < 7000) && (!Screen.key())) {
		Screen.clear(rDepthBuffer);
		Screen.videoBuffer.clear(Rect<float>(0.0f, 30.0f/240.0f, 1.0f, 180.0f/240.0f));
		float x = FadeFlashblack1.getValue(t, 0);
		float av = project_cv.getValue(t, 0);

		project.genPal(1, 255, av/64.0f, av/64.0f);  
		project.paint(Screen.videoBuffer);

 		tiger.paint(t);
				
 		trama1.paint(Screen.videoBuffer);
		trama2.paint(Screen.videoBuffer);

 		FadeFlash::run(Screen.videoBuffer, x/64);
		FPS_COUNT();
		SHOW_STATS();
		Screen.flush();
	}
	//module.stop(); 

	Screen.viewport(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);

	//*********************** EMPIEZA LA DEMO**************************


	Bitmap portada;
	Bitmap portada_up;
	Bitmap portada_down;

	FileManager.loadBitmap("portada", portada);

	portada.prepare(Screen.videoBuffer);
	portada.paint(Screen.videoBuffer);
	Screen.flush();


	module.load("ab_sp00.it");
	Timer.start();
  	module.start();

	FileManager.loadBitmap("portada_up", portada_up);
	FileManager.loadBitmap("portada_down", portada_down);

	Key c;
	c.code = 0;

	//******************** LOADING ***********************************	

	Scene3D scene, cartel;
	FileManager.loadScene3D("scene", scene);
	FileManager.loadScene3D("cartel", cartel);
	scene.prepare(Screen);
	cartel.prepare(Screen);

	scene.set("Box01", Option::ZBufRead, false);
	scene.set("Box01", Option::ZBufWrite, false);

	scene.set(NULL, Option::BoundingTest, false);

	cartel.set(NULL, Option::BoundingTest, false);
	
	Bitmap pers[19];

	int count;
	for (count = 0; (count < 19) && (c.code != ESCAPE); count++) {
		char String[200];
		sprintf(String, "Sprites/Persosp_%02i", count+1);
		FileManager.loadBitmap(String, pers[count]);
		pers[count].prepare(Screen.videoBuffer);
		pers[count].set(Option::CenterX, 0.5f);
		pers[count].set(Option::CenterY, 1.0f);

		if (Screen.key()) {
			c = Screen.read();
		}
	}

	BitmapFont Expo, ExpoBlack;
	FileManager.loadBitmapFont("Expo", Expo);
	FileManager.loadBitmapFont("Expo", ExpoBlack);
	Expo.fontData.convert(ColorFormat::IndexedRGB32);
	Expo.fontData.set(DrawMode::TranspAlpha);
	ExpoBlack.fontData.convert(ColorFormat::IndexedRGB32);
	ExpoBlack.fontData.set(DrawMode::TranspAlpha);

	Color4 White(1.0f, 1.0f, 1.0f, 1.0f);
	Expo.set(White);
	Color4 Black(0.0f, 0.0f, 0.0f, 1.0f);
	ExpoBlack.set(Black);

	Texture Rectangulo, Rectangulo2;
	FileManager.loadBitmap("Rectangulo", Rectangulo);
	FileManager.loadBitmap("Rectangulo", Rectangulo2);
	Rectangulo.set(DrawMode::TranspSub);
	Rectangulo2.set(DrawMode::TranspSub);
	Rectangulo.prepare(Screen.videoBuffer);

	Bitmap TextBuffer[5];
	Bitmap Photo[30];
	count = 0;

	do {
		switch (count) {
		case 0:
			LoadJPG("Photos/acid_jaco.jpg", Photo[0]);
			break;
		case 1:
			LoadJPG("Photos/acid_dj.jpg", Photo[1]);
			break;
		case 2:
			LoadJPG("Photos/carlos.jpg", Photo[2]);
			break;
		case 3:
			LoadJPG("Photos/chillout.jpg", Photo[3]);
			break;
		case 4:
			LoadJPG("Photos/culpa_ufix.jpg", Photo[4]);
			break;
		case 5:
			LoadJPG("Photos/dancing.jpg", Photo[5]);
			break;
		case 6:
			LoadJPG("Photos/dvd.jpg", Photo[6]);
			break;
		case 7:
			LoadJPG("Photos/general.jpg", Photo[7]);
			break;
		case 8:
			LoadJPG("Photos/gonzalo.jpg", Photo[8]);
			break;
		case 9:
			LoadJPG("Photos/hernan.jpg", Photo[9]);
			break;
		case 10:
			LoadJPG("Photos/jaco.jpg", Photo[10]);
			break;
		case 11:
			LoadJPG("Photos/jacobo.jpg", Photo[11]);
			break;
		case 12:
			LoadJPG("Photos/jamque.jpg", Photo[12]);
			break;
		case 13:
			LoadJPG("Photos/javier.jpg", Photo[13]);
			break;
		case 14:
			LoadJPG("Photos/maria_mauri.jpg", Photo[14]);
			break;
		case 15:
			LoadJPG("Photos/mc303.jpg", Photo[15]);
			break;
		case 16:
			LoadJPG("Photos/miguel_angel.jpg", Photo[16]);
			break;
		case 17:
			LoadJPG("Photos/pasop.jpg", Photo[17]);
			break;
		case 18:
			LoadJPG("Photos/proyector.jpg", Photo[18]);
			break;
		case 19:
			LoadJPG("Photos/scener_lights.jpg", Photo[19]);
			break;
		case 20:
			LoadJPG("Photos/sceners_dance.jpg", Photo[20]);
			break;
		case 21:
			LoadJPG("Photos/sml_dvd_djs.jpg", Photo[21]);
			break;
		case 22:
			LoadJPG("Photos/sml.jpg", Photo[22]);
			break;
		case 23:
			LoadJPG("Photos/sml_dj.jpg", Photo[23]);
			break;
		case 24:
			LoadJPG("Photos/sml_suxx.jpg", Photo[24]);
			break;
		case 25:
			LoadJPG("Photos/tai.jpg", Photo[25]);
			break;
		case 26:
			LoadJPG("Photos/tinglao.jpg", Photo[26]);
			break;
		case 27:
			LoadJPG("Photos/trace.jpg", Photo[27]);
			break;
		case 28:
			LoadJPG("Photos/trace_pasop_co.jpg", Photo[28]);
			break;
		case 29:
			LoadJPG("Photos/ufix.jpg", Photo[29]);
			break;
		default: 
			break;
		}

		Photo[count].prepare(Screen.videoBuffer);
		Screen.flush();

		if (Screen.key()) {
			c = Screen.read();
		}

		count++;

	} while ((count < 30) && (c.code != ESCAPE));

	//********************** TITULO ******************************	

	if (c.code != ESCAPE) {
		Rectangulo2.convert(ColorFormat::IndexedRGB32);
		for (int i = 0; i < 4; i++) {
			TextBuffer[i].init((int)(SCREEN_WIDTH*270.0f/640.0f), (int)(SCREEN_HEIGHT*194.0f/480.0f), ColorFormat::DirectRGB32);
			TextBuffer[i].clear(Color4(1.0f, 1.0f, 1.0f, 1.0f));
			Rectangulo2.paint(TextBuffer[i]);
		}
		TextBuffer[4].init((int)(SCREEN_WIDTH*270.0f/640.0f), (int)(SCREEN_HEIGHT*194.0f/480.0f), Screen.videoBuffer.colorFormat);
 
		TextBuffer[4].set(Option::TargetRect, Rect<float>(16.0f/640.0f, 252.0f/480.0f, 270.0f/640.0f, 194.0f/480.0f));
		
		float targetScreenWidth = ExpoBlack.targetScreenWidth;
		float targetScreenHeight = ExpoBlack.targetScreenHeight;

		ExpoBlack.targetScreenWidth = (float) TextBuffer[0].width;
		ExpoBlack.targetScreenHeight = (float) TextBuffer[0].height;

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.54f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("01.    garaje", TextBuffer[0]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.60f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("20.   sceners", TextBuffer[0]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.66f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("02. ordenatas", TextBuffer[0]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.79f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("Polish - Style", TextBuffer[0]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.86f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("Parties Rulezz!!", TextBuffer[0]);


		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.55f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("Code:Dr.Kami", TextBuffer[1]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.61f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("Gfx:acidbeat", TextBuffer[1]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.67f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("Scenes:JamQue", TextBuffer[1]);
		
		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.73f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("Photos:acidbeat", TextBuffer[1]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.79f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("Design:trace", TextBuffer[1]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.85f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("Muzak:acidbeat", TextBuffer[1]);


		ExpoBlack.set(Option::CharWidth, 0.65f);
		ExpoBlack.set(Option::CharHeight, 0.65f);
		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.55f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("left y right:", TextBuffer[2]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.61f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint(" . cambiar de foto", TextBuffer[2]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.67f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("arriba y abajo:", TextBuffer[2]);
		
		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.73f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint(" . scrollear el texto", TextBuffer[2]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.79f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("Espacio: Ocultar texto", TextBuffer[2]);

		ExpoBlack.set(Option::PosX, ((0.04f*640.0f)-16.0f)/270.0f);
		ExpoBlack.set(Option::PosY, ((0.85f*480.0f)-252.0f)/194.0f);
		ExpoBlack.paint("Escape: Salir", TextBuffer[2]);


		ExpoBlack.targetScreenWidth = targetScreenWidth;
		ExpoBlack.targetScreenHeight = targetScreenHeight;

		Rectangulo2.convert(ColorFormat::IndexedRGB16);

		
		Expo.set(Justification::Left);
		Screen.videoBuffer.viewport(Rect<DWord>((DWord)(SCREEN_WIDTH*25.0f/640.0f), (DWord)(SCREEN_HEIGHT*(480.0f-102.0f-25.0f)/480.0f), (DWord)(SCREEN_WIDTH*590.0f/640.0f), (DWord)(SCREEN_HEIGHT*102.0f/480.0f)));
		for (count = 0; count < 30; count++) {
			Expo.set(Option::PosX, 0.0f);
			Expo.justify(Textos[count], TextosJ[count], Screen.videoBuffer);
			Lines[count] = 1;
			for (int i = 0; TextosJ[count][i] != 0; i++) { 
				if (TextosJ[count][i] == '\n') {
					Lines[count]++;
				}
			}
		}
		Screen.videoBuffer.viewport(Rect<DWord>(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT));
		count = 0;

		portada_up.set(Option::TargetRect, Rect<float>(0.0f, 0.0f, 1.0f, portada_up.height/480.0f));
		portada_up.prepare(Screen.videoBuffer);

		//WAIT
		portada_down.set(Option::TargetRect, Rect<float>(0.0f, 1.0f-(portada_down.height/480.0f), 1.0f, portada_down.height/480.0f));
		portada_down.prepare(Screen.videoBuffer);
	}

	while ((Timer.getMillis() < 16500) && (c.code != ESCAPE)) {

		if (Screen.key()) {
			c = Screen.read();
		}
		Screen.flush();
	}

	if (c.code != ESCAPE) {
		portada_up.paint(Screen.videoBuffer);
		portada_down.paint(Screen.videoBuffer);
	}

	while ((Timer.getMillis() < 21619) && (c.code != ESCAPE)) {
		if (Screen.key()) {
			c = Screen.read();
		}
		
		Screen.flush();
	}

	//********************** CREDITS ******************************	

	Screen.clearColor(Color3(1.0f, 1.0f, 1.0f));

	int oldCount = -1;
	int index = -1;
	int persFlag[19];
	for (count = 0; count < 19; count++) {
		persFlag[count] = 0;
	}
	count = 0;
    srand((unsigned)time(NULL));

	while (((t = Timer.getMillis()) < 64600) && (c.code != ESCAPE)) {
		
		Screen.viewport(0, 0, 640, 480);
		Screen.clear(rColorBuffer | rDepthBuffer);

		Rectangulo2.set(Option::TargetRect, Rect<float>(16.0f/640.0f, 40.0f/480.0f, 450.0f/640.0f, 120.0f/480.0f));
		Rectangulo2.paint(Screen.videoBuffer);

		Expo.set(Option::CharWidth, 0.3f);
		Expo.set(Option::CharHeight, 0.3f);
		Expo.set(Option::PosX, 19.0f/640.0f);
		Expo.set(Option::PosY, 150.0f/480.0f);
		Expo.paint("F U Z Z I O N", Screen.videoBuffer);
		Expo.set(Option::CharWidth, 1.0f);
		Expo.set(Option::CharHeight, 1.0f);

		if (t > (a+b)) { 
			Rectangulo2.set(Option::TargetRect, Rect<float>(315.0f/640.0f, 176.0f/480.0f, 150.0f/640.0f, 15.0f/480.0f));
			Rectangulo2.paint(Screen.videoBuffer);
		}
				
		Screen.viewport(10, 10, 260, 180);
						
		cartel.paint(t-21619);
		Screen.viewport(SCREEN_WIDTH/2, SCREEN_HEIGHT/2, SCREEN_WIDTH-SCREEN_WIDTH/2, SCREEN_HEIGHT-SCREEN_HEIGHT/2);
  		scene.paint(t-21619);

		count = -1;

		// SINCRONIZACION DE LOS TIOS PRESENTES ////////////////////////////////////////////
		
		if ((t > a + b) && (t < (a*2) + b)) { 
			count = 0;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*2) + b) && (t < (a*3) + b)) {
			count = 1;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}
		
		if ((t > (a*3) + b) && (t < (a*4) + b)) {
			count = 2;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*4) + b) && (t < (a*5) + b)) {
			count = 3;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*5)+b) && (t < (a*6)+b)) {
			count = 4;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*6)+b) && (t < (a*7)+b)) {
			count = 5;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*7)+b) && (t < (a*8)+b)) {
			count = 6;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*8)+b) && (t < (a*9)+b)) {
			count = 7;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*9)+b) && (t < (a*10)+b)) {
			count = 8;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*10)+b) && (t < (a*11)+b)) {
			count = 9;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*11)+b) && (t < (a*12)+b)) {
			count = 10;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*12)+b) && (t < (a*13)+b)) {
			count = 11;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*13)+b) && (t < (a*14)+b)) {
			count = 12;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*14)+b) && (t < (a*15)+b)) {
			count = 13;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*15)+b) && (t < (a*16)+b)) {
			count = 14;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*16)+b) && (t < (a*17)+b)) {
			count = 15;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*17)+b) && (t < (a*18)+b)) {
			count = 16;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*18)+b) && (t < (a*19)+b)) {
			count = 17;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*19)+b) && (t < (a*20)+b)) {
			count = 18;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>0);
				persFlag[index]++;
				oldCount = count;
			}
		}


////////////////////// VUELVE A EMPEZAR ////////////////////////////////////////


		if ((t > (a*20)+b) && (t < (a*21) + b)) { 
			count = 0;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>1);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*21) + b) && (t < (a*22) + b)) {
			count = 1;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>1);
				persFlag[index]++;
				oldCount = count;
			}
		}
		
		if ((t > (a*22) + b) && (t < (a*23) + b)) {
			count = 2;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>1);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*23) + b) && (t < (a*24) + b)) {
			count = 3;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>1);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*24)+b) && (t < (a*25)+b)) {
			count = 4;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>1);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*25)+b) && (t < (a*26)+b)) {
			count = 5;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>1);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*26)+b) && (t < (a*27)+b)) {
			count = 6;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>1);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*27)+b) && (t < (a*28)+b)) {
			count = 7;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>1);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*28)+b) && (t < (a*29)+b)) {
			count = 8;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>1);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if ((t > (a*29)+b) && (t < (a*30)+b)) {
			count = 9;
			if (count != oldCount) {
				do {
					index = rand()%19;
				} while (persFlag[index]>1);
				persFlag[index]++;
				oldCount = count;
			}
		}

		if (count >= 0) {
			pers[index].set(Option::TargetRect, Rect<float>(0.85f, 0.45f, (float)pers[index].width/640.0f, (float)pers[index].height/480.0f));
			pers[index].paint(Screen.videoBuffer);
		}
		

		ExpoBlack.set(Option::CharWidth, 1.0f);
		ExpoBlack.set(Option::CharHeight, 1.0f);

		if (count >= 0) {
			Expo.set(Option::PosX, 287.0f/640.0f);
			Expo.set(Option::PosY, 39.0f/480.0f);
			Expo.paint("LA GENTE", Screen.videoBuffer);
			Expo.set(Option::PosX, 397.0f/640.0f);
			Expo.set(Option::PosY, 71.0f/480.0f);
			Expo.paint("QUE", Screen.videoBuffer);
			Expo.set(Option::PosX, 280.0f/640.0f);
			Expo.set(Option::PosY, 106.0f/480.0f);
			Expo.paint("ASISTIO A", Screen.videoBuffer);
			Expo.set(Option::PosX, 288.0f/640.0f);
			Expo.set(Option::PosY, 140.0f/480.0f);
			Expo.paint("LA PARTY", Screen.videoBuffer);

			switch (index) {
			case -1:
				break;
			case 0:
				ExpoBlack.set(Option::PosX, 335.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Jacobo", Screen.videoBuffer);
				break;
			case 1:
				ExpoBlack.set(Option::PosX, 324.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Dr.Kami", Screen.videoBuffer);
				break;
			case 2:
				ExpoBlack.set(Option::PosX, 336.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Carlos", Screen.videoBuffer);
				break;
			case 3:
				ExpoBlack.set(Option::PosX, 329.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Gonzalo", Screen.videoBuffer);
				break;
			case 4:
				ExpoBlack.set(Option::PosX, 327.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("JamQue", Screen.videoBuffer);
				break;
			case 5:
				ExpoBlack.set(Option::PosX, 360.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Tai", Screen.videoBuffer);
				break;
			case 6:
				ExpoBlack.set(Option::PosX, 328.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Carmen", Screen.videoBuffer);
				break;
			case 7:
				ExpoBlack.set(Option::PosX, 347.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("trace", Screen.videoBuffer);
				break;
			case 8:
				ExpoBlack.set(Option::PosX, 340.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Maria", Screen.videoBuffer);
				break;
			case 9:
				ExpoBlack.set(Option::PosX, 353.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("dVD", Screen.videoBuffer);
				break;
			case 10:
				ExpoBlack.set(Option::PosX, 340.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Pasop", Screen.videoBuffer);
				break;
			case 11:
				ExpoBlack.set(Option::PosX, 331.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Hernan", Screen.videoBuffer);
				break;
			case 12:
				ExpoBlack.set(Option::PosX, 350.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Ufix", Screen.videoBuffer);
				break;
			case 13:
				ExpoBlack.set(Option::PosX, 364.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Ivo", Screen.videoBuffer);
				break;
			case 14:
				ExpoBlack.set(Option::PosX, 340.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Mauri", Screen.videoBuffer);
				break;
			case 15:
				ExpoBlack.set(Option::PosX, 322.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("acidbeat", Screen.videoBuffer);
				break;
			case 16:
				ExpoBlack.set(Option::PosX, 353.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Sml", Screen.videoBuffer);
				break;
			case 17:
				ExpoBlack.set(Option::PosX, 349.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Fran", Screen.videoBuffer);
				break;
			case 18:
				ExpoBlack.set(Option::PosX, 339.0f/640.0f);
				ExpoBlack.set(Option::PosY, 172.0f/480.0f);

				ExpoBlack.paint("Javier", Screen.videoBuffer);
				break;
			}
		}

		float k = 0.0f;

		if ((t > 32300) && (t < 37300)) {
			//PINTA PRIMER TEXTO
			TextBuffer[0].convert(TextBuffer[4]);
			TextBuffer[4].paint(Screen.videoBuffer);
		}

		if ((t > 37300) && (t < 39300)) {
			//CROSSFADE PRIMER-SEGUNDO TEXTO
			
			k= (t - 37300) / 2000.0f;
				
			TextBuffer[0].paint(TextBuffer[3]);
			CrossFade::run(TextBuffer[3], TextBuffer[1], k);
			TextBuffer[3].convert(TextBuffer[4]);
			TextBuffer[4].paint(Screen.videoBuffer);
		}

		if ((t > 39300) && (t < 44300)) {
			//PINTA SEGUNDO TEXTO
			TextBuffer[1].convert(TextBuffer[4]);
			TextBuffer[4].paint(Screen.videoBuffer);
		}

		if ((t > 44300) && (t < 46300)) {
			//CROSSFADE SEGUNDO-TERCER TEXTO

			k= (t - 44300) / 2000.0f;

			TextBuffer[1].paint(TextBuffer[3]);
			CrossFade::run(TextBuffer[3], TextBuffer[2], k);
			TextBuffer[3].convert(TextBuffer[4]);
			TextBuffer[4].paint(Screen.videoBuffer);
		}

		if (t > 46300) {
			//PINTA TERCER TEXTO
			TextBuffer[2].convert(TextBuffer[4]);
			TextBuffer[4].paint(Screen.videoBuffer);
		}

		if (t < 22619) {
	 		FadeFlash::run(Screen.videoBuffer, 2.0f-((float)(t-21619)/1000.0f));
		}

		if ((t > 32300) && (t < 33300)) {
	 		FadeFlash::run(Screen.videoBuffer, 2.0f-((float)(t-32300)/1000.0f));
		}

		if (t > 63000) {
	 		FadeFlash::run(Screen.videoBuffer, 1.0f+((float)(t-63000)/1600.0f));
		}

		if (Screen.key()) {
			c = Screen.read();
		}

		Screen.flush();
	}

	//********************** PHOTO-SHOW ******************************	

	bool ShowEndPhoto;
	if (c.code != ESCAPE) {
		ShowEndPhoto = true;
	} else {
		ShowEndPhoto = false;
	}

	float posY = 0.0f;
	oldCount = -1;
	count = 0;
	bool showRect = true;

	float inc = 0.0f;	
	int lastTimeKeyPress = 0;
	while (c.code != ESCAPE) {
		if (oldCount != count) {
			Photo[count].paint(Screen.videoBuffer);
			oldCount = count;
		} else {
			Screen.videoBuffer.region(Rect<DWord>((DWord)(SCREEN_WIDTH*20.0f/640.0f), (DWord)(SCREEN_HEIGHT*(480.0f-112.0f-20.0f)/480.0f), (DWord)(SCREEN_WIDTH*600.0f/640.0f), (DWord)(SCREEN_HEIGHT*112.0f/480.0f)));
			Photo[count].paint(Screen.videoBuffer);
		}
		
		if (showRect) {
			Screen.videoBuffer.viewport(Rect<DWord>((DWord)(SCREEN_WIDTH*20.0f/640.0f), (DWord)(SCREEN_HEIGHT*(480.0f-112.0f-20.0f)/480.0f), (DWord)(SCREEN_WIDTH*600.0f/640.0f), (DWord)(SCREEN_HEIGHT*112.0f/480.0f)));
			Rectangulo.paint(Screen.videoBuffer);
			Screen.videoBuffer.viewport(Rect<DWord>((DWord)(SCREEN_WIDTH*25.0f/640.0f), (DWord)(SCREEN_HEIGHT*(480.0f-102.0f-25.0f)/480.0f), (DWord)(SCREEN_WIDTH*590.0f/640.0f), (DWord)(SCREEN_HEIGHT*102.0f/480.0f)));

			Expo.set(Option::PosX, 0.0f);
			Expo.set(Option::PosY, posY);
			Expo.paint(TextosJ[count], Screen.videoBuffer);
		}

		if (Screen.key()) {
			c = Screen.read();
			if (c.code == LEFT) {
				if (count > 0) {
					count--;
				}
				posY = 0.0f;
				inc = 0.0f;
			}
			if (c.code == RIGHT) {
				if (count < 29) {
					count++;
				}
				posY = 0.0f;
				inc = 0.0f;
			}

			if (c.code == UP) {
				inc = 2.0f/SCREEN_HEIGHT;
				lastTimeKeyPress = Timer.getMillis();
			}
			if (c.code == DOWN) {
				inc = -2.0f/SCREEN_HEIGHT;
				lastTimeKeyPress = Timer.getMillis();
			}

			if (c.code == SPACE) {
				if (showRect) {
					showRect = false;
				} else {
					showRect = true;
				}
			}
		}

		if (inc > 0.0f) {
			if (posY < -2.0f/SCREEN_HEIGHT) {
				posY += inc;

				if ((Timer.getMillis()-lastTimeKeyPress) > 200) {
					inc -= 0.2f/SCREEN_HEIGHT;
					if (inc < 0.0f) {
						inc = 0.0f;
					}
				}
			} else {
				inc = 0.0f;
			}
		}
			
		if (inc < 0.0f) {
			if (Lines[count] > 3) {
				if (posY > -((float)((Lines[count]-3)*Expo.fontData.height)/(float)SCREEN_HEIGHT)) {
					posY += inc;

					if ((Timer.getMillis()-lastTimeKeyPress) > 200) {
						inc += 0.2f/SCREEN_HEIGHT;
						if (inc > 0.0f) {
							inc = 0.0f;
						}
					}
				} else {
					inc = 0.0f;
				}
			}
		}

		Screen.videoBuffer.viewport(Rect<DWord>(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT));

		Screen.flush();
	}

	//********************** THE END ******************************	

	if (ShowEndPhoto) {
		Bitmap TheEnd;
		FileManager.loadBitmap("trc_jmq.pcx", TheEnd);

		TheEnd.prepare(Screen.videoBuffer);
		TheEnd.paint(Screen.videoBuffer);
		Expo.set(Option::PosX, 0.76f);
		Expo.set(Option::PosY, 0.95f);
		Expo.paint("The End", Screen.videoBuffer);

		Screen.flush();

		c.code = 0;		
		speaker.fade(0, 20);

		int time = Timer.getMillis();

		while (((t = (Timer.getMillis()-time)) < 4000) && (c.code != ESCAPE)) {
			if (Screen.key()) {
				c = Screen.read();
			}

			Screen.flush();
		}

		while (((t = (Timer.getMillis()-time)) < 7000) && (c.code != ESCAPE)) {
			if (Screen.key()) {
				c = Screen.read();
			}
			
			TheEnd.paint(Screen.videoBuffer);
			Expo.set(Option::PosX, 0.74f);
			Expo.set(Option::PosY, 0.95f);
			Expo.paint("The End...", Screen.videoBuffer);

			FadeFlash::run(Screen.videoBuffer, 1.0f-((float)(t-4000)/3000.0f));

			Screen.flush();
		}
	}

	module.stop();
	speaker.close();
}